<x-app-layout>
    <x-slot name="header">
        {{ucfirst($role->name)}} Permissions
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.role.update', $role->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="container-fluid">
                            <div class="row mb-4">
                                @foreach ($permissions as $groupName => $group)
                                    <div class="col-md-12 mb-4">
                                        <div class="card shadow-sm">
                                            <div class="card-header bg-light">
                                                <h5 class="mb-0">{{ ucwords($groupName) }}</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="row g-3">
                                                    @foreach ($group as $permission)
                                                        <div class="col-md-3">
                                                            <div class="form-check custom-checkbox">
                                                                <input
                                                                    type="checkbox"
                                                                    class="form-check-input"
                                                                    id="permission_{{ $permission->id }}"
                                                                    name="permissions[]"
                                                                    value="{{ $permission->name }}"
                                                                    @checked($role->hasPermissionTo($permission->name))
                                                                >
                                                                <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                                    {{ ucwords(str_replace('-', ' ', $permission->name)) }}
                                                                </label>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary px-4">
                                        <i class="fas fa-save me-2"></i>Update Permissions
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

</x-app-layout>
